
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1007.C - Message 1007 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1007 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1007.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:46   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:38:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:18   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:36:18   COLEJ
//   Repositioned sequence number and satmeasseqnum.
//   
//      Rev 1.0   13 May 1996 14:52:44   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

tDOUBLE trip2dbl (tTRIPLE *x);

//extern  tZMSG ZMsg;


////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1007 message from the ZMsgBuf.
//      
void Dec1007(tMSGBUF *ZMsgBuf, tMSG1007 *Msg)
{
   tSHORT i;

   GetShort  (&Msg->SequenceNumber     , ZMsgBuf,       8); // ND  
   GetShort  (&Msg->SatMeasSeqNum      , ZMsgBuf,       9); // ND  
  
   for(i=0; i<GI_NUM_HW_CHAN; i++)  { 
   GetTriple(&Msg->ChanSum[i].PseudoRange    , ZMsgBuf, 10+12*i); // 1E+03 * meters      
   GetLong  (&Msg->ChanSum[i].PseudoRangeRate, ZMsgBuf, 13+12*i); // 1E+03 * meters/sec    
   GetTriple(&Msg->ChanSum[i].IntegratedPhase, ZMsgBuf, 15+12*i); // 1E+03 * meters      
   GetTriple(&Msg->ChanSum[i].IntegPhaseBias , ZMsgBuf, 18+12*i); // 1E+03 * meters
   GetUShort(&Msg->ChanSum[i].PhaseBiasCount , ZMsgBuf, 21+12*i); // ND
   }         
}                  

                                
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1007 message in the ZMsgBuf. 
//
void Bld1007(tMSGBUF *ZMsgBuf, tMSG1007 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                       , ZMsgBuf, 1);         // message preamble
   PutShort  (1007                         , ZMsgBuf, 2);         // message number
   PutShort  (0                            , ZMsgBuf, 3);         // message length 
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);         // header check sum
 
 //PutShort  (CheckSum(ZMsgBuf, 6, 197)    , ZMsgBuf, 2);   // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1007 message from the ZMsgBuf.
//      
void Show1007(tMSG1007 *Msg)
{  
   char    Buf[80] = ""; 
   tSHORT  i;   
   
   extern short  xtract;  
   extern char   xtractid[4]; 
   
   extern FILE   *stream3;
 
   double  PseudoRange    [GI_NUM_HW_CHAN];
   double  PseudoRangeRate[GI_NUM_HW_CHAN];
   double  IntegratedPhase[GI_NUM_HW_CHAN];
   double  IntegPhaseBias [GI_NUM_HW_CHAN];  

   // convert values  
   
   // perform special processing for output
   for(i=0; i<GI_NUM_HW_CHAN; i++)  { 
   PseudoRange[i]     = trip2dbl(&Msg->ChanSum[i].PseudoRange    ) / 1E+03;
   IntegratedPhase[i] = trip2dbl(&Msg->ChanSum[i].IntegratedPhase) / 1E+03;
   IntegPhaseBias[i]  = trip2dbl(&Msg->ChanSum[i].IntegPhaseBias ) / 1E+03;
   PseudoRangeRate[i] = Msg->ChanSum[i].PseudoRangeRate            / 1E+03;
   }   
   
   // write extracted data to a file
   if(xtract){
      if(strcmp(xtractid,"RNG") == 0){     
        // fprintf(stream3, "%6ld \t%10.6f \t%11.6f \t%9.2f\n",      
        //         Msg->GPSTimeSeconds, Longitude, Latitude, Height);                     
      }
      else if(strcmp(xtractid,"DIF") == 0){     
         // TBD
      } 
   }                                
                                                      
   // output the data values   
   sprintf(Buf,"%05d"   ,Msg->SequenceNumber     );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%05d"   ,Msg->SatMeasSeqNum      );ShowText(Buf,TIMR+ 6,TIMC+12); 

   for(i=0; i<GI_NUM_HW_CHAN; i++){   
   if(Msg->ChanSum[i].PseudoRangeRate != 0){ 
   sprintf(Buf,"%12.3lf",IntegratedPhase[i]      );ShowText(Buf,CPMR+ i,CPMC   ); 
   sprintf(Buf,"%12.3lf",PseudoRange[i]          );ShowText(Buf,PRMR+ i,PRMC   ); 
   sprintf(Buf,"%9.3lf" ,PseudoRangeRate[i]      );ShowText(Buf,PRMR+ i,PRMC+13);
   sprintf(Buf,"%11.3lf",IntegPhaseBias[i]       );ShowText(Buf,CPBR+ i,CPBC   );
   }
   else{
   sprintf(Buf,"            "                    );ShowText(Buf,CPMR+ i,CPMC   ); 
   sprintf(Buf,"            "                    );ShowText(Buf,PRMR+ i,PRMC   ); 
   sprintf(Buf,"         "                       );ShowText(Buf,PRMR+ i,PRMC+13);
   sprintf(Buf,"           "                     );ShowText(Buf,CPBR+ i,CPBC   );
   }
   }
}
